#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//tri-Sierpinski triangle zoomMod01.fsh   by   FabriceNeyret2  
//https://www.shadertoy.com/view/7sScWK
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define R iResolution.xy

float line(vec2 p, vec2 a,vec2 b) { 
    p -= a, b -= a;
    float h = clamp(dot(p, b) / dot(b, b), 0., 1.);   // proj coord on line
    return length(p - b * h);                         // dist to segment
}

float t, T;

float S( vec2 U ) {                                   // === Sierpinski triangle
     float O = 0., l, s = R.y/T;
     U *= T;
     for (int i=int(log2(R.y))-1; i>=0; i--, s/=2.) { // fractal loop
         l = min( line(U,vec2(0,0),vec2(1,0)),        
                  line(U,vec2(0,0),vec2(.5,.87)) );   // triangle
        l = min(l,line(U,vec2(1,0),vec2(.5,.87)) );
        O = max(O, smoothstep(1.5,0.,l*s ) * (i>0 ? 1. : t ) ); // fade last
        U *= 2.;                                      // fractal recursion: 3 branches
        if (U.y > .86) U.x-=.5, U.y-=.87;
        else if (U.x > 1.) U.x--;   
    }  
    return O;
}
#define O fragColor
#define u fragCoord
//void mainImage(out vec4 O, vec2 u) { 
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{                 // ==========================
     vec2  U = ( u - .5*R ) /R.y + vec2(.12,.3);
           t = fract(.3*iTime),
           T = exp2(-t);                              // zoom factor

    fragColor = vec4( S(U),                                   // draw the 3 triangles
              S(U+vec2(.755,.43)+ (1./T-1.)*vec2(.5,.87) ), 
              S(U+vec2(.748 +1./T-1.,-.44) ),  1 );
    fragColor = mix( O, vec4(O.r+O.g+O.b), .5);               // desaturate
    fragColor = sqrt(O);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

